<?php
extract ( shortcode_atts ( array (
	'title' => esc_html__( 'Title', 'semona-extension' ),
	'value' => '50',
	'unit' => '%',
	'shape' => '',
	'style' => '',
	'fg_style' => '',
	'fg_color' => '',
	'custom_fg_color' => '',
	'grad_color1' => '',
	'custom_grad_color1' => '',
	'grad_color2' => '',
	'custom_grad_color2' => '',
	'bg_color' => '',
	'text_color' => '',
	'css_animation' => '',
	'animation_delay' => '',
	'el_class' => '', 
), $atts ) );
$css_class = array( "sm-progressbar", "sm_content_element" );
$scoped_css = '';

$id = sm_shortcode_unique_id( "sm-progressbar" );
$css_gen = new Inline_CSS_Generator( "sm-progressbar", $id );

$shape = sm_validate_with_array( $shape, sm_get_progressbar_shapes_array() );
$css_class[] = $shape;

$style = sm_validate_with_array( $style, sm_get_progressbar_styles_array() );
$css_class[] = $style;

$fg_style = sm_validate_with_array( $fg_style, sm_get_background_styles_array() );
// Validate the preset color values.
$preset_colors = sm_get_preset_colors_array( false, false );

$fg_color = sm_validate_with_array( $fg_color, $preset_colors );
$grad_color1 = sm_validate_with_array( $grad_color1, $preset_colors );
$grad_color2 = sm_validate_with_array( $grad_color2, $preset_colors );

if ( 'sm-style-gradient' == $fg_style ) { // Gradient
	if ( $grad_color1 != 'custom' ) {
		$custom_grad_color1 = sm_get_color_code_by_name( $grad_color1 );
	}
	if ( $grad_color2 != 'custom' ) {
		$custom_grad_color2 = sm_get_color_code_by_name( $grad_color2 );
	}

	$scoped_css .= '#' . $id . '.sm-progressbar .gauge{';
	$scoped_css .= sm_get_bg_img_gradient_css( $custom_grad_color1, $custom_grad_color2, 90 );
	$scoped_css .= '}';
} else if ( 'sm-style-def-grad1' == $fg_style || 'sm-style-def-grad2' == $fg_style ) { 
	$css_class[] = $fg_style;
} else {
	if ( 'custom' == $fg_color ) {
		$scoped_css .= $css_gen->css( '.gauge', array( 'background-color' => $custom_fg_color ) );
	} else {
		$css_class[] = $fg_color;
	}
}

if ( !empty( $bg_color ) ) {
	if ( $style == 'sm-style-outline' ) {
		$scoped_css .= $css_gen->css( '.meter', array( 'border-color' => $bg_color ) );
	} else {
		$scoped_css .= $css_gen->css( '.meter', array( 'background-color' => $bg_color ) );
	}
}

if ( !empty( $text_color ) ) {
	$scoped_css .= $css_gen->css( '.title', array( 'color' => $text_color ) );
}

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_css_animation( $css_animation );
$css_class .= sm_get_extra_class( $el_class );
if ( empty( $title ) ) $title = '&nbsp;';

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
$wrapper_attributes[] = 'data-value="' . esc_attr( $value ) . '"';
if ( intval( $animation_delay ) > 0 ) {
	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
}

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<?php sm_the_scoped_css( $scoped_css ); ?>
	<h4 class='title'><?php echo esc_html( $title ); ?></h4>
	<div class="meter">
		<div class="gauge">
			<div class='value'><span><?php echo esc_html( $value ); ?></span><?php echo esc_html( $unit ) ?></div>
		</div>
	</div>
</div>